/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ui;

import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.ui.LockListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class LockedObjects {
    private HashSet lockedObjects = new HashSet();
    private List listeners = new ArrayList();

    private LockedObjects() {
    }

    public static LockedObjects getLockedObjects(HMCSession hmcSession) {
        LockedObjects lo = (LockedObjects)hmcSession.getSessionAttribute("com.ibm.hwmca.fw.ui.LockedObjects");
        if (lo == null) {
            lo = new LockedObjects();
            hmcSession.setSessionAttribute("com.ibm.hwmca.fw.ui.LockedObjects", lo);
        }
        return lo;
    }

    public static LockedObjects getLockedObjects() {
        return new LockedObjects();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLockListener(LockListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLockListener(LockListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(ObjectId objectId) {
        boolean changed = false;
        HashSet hashSet = this.lockedObjects;
        synchronized (hashSet) {
            changed = this.lockedObjects.add(objectId);
        }
        if (changed) {
            this.notifyListeners(true, new ObjectId[]{objectId});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(ObjectId[] objectIds) {
        ArrayList<ObjectId> lockedObjectIds = new ArrayList<ObjectId>();
        HashSet hashSet = this.lockedObjects;
        synchronized (hashSet) {
            int i = 0;
            while (i < objectIds.length) {
                if (this.lockedObjects.add(objectIds[i])) {
                    lockedObjectIds.add(objectIds[i]);
                }
                ++i;
            }
        }
        if (lockedObjectIds.size() > 0) {
            this.notifyListeners(true, lockedObjectIds.toArray(new ObjectId[lockedObjectIds.size()]));
        }
    }

    public void lock(Set objectIds) {
        this.lock(objectIds.toArray(new ObjectId[objectIds.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(ObjectId objectId) {
        boolean changed = false;
        HashSet hashSet = this.lockedObjects;
        synchronized (hashSet) {
            changed = this.lockedObjects.remove(objectId);
        }
        if (changed) {
            this.notifyListeners(false, new ObjectId[]{objectId});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(ObjectId[] objectIds) {
        ArrayList<ObjectId> unlockedObjectIds = new ArrayList<ObjectId>();
        HashSet hashSet = this.lockedObjects;
        synchronized (hashSet) {
            int i = 0;
            while (i < objectIds.length) {
                if (this.lockedObjects.remove(objectIds[i])) {
                    unlockedObjectIds.add(objectIds[i]);
                }
                ++i;
            }
        }
        if (unlockedObjectIds.size() > 0) {
            this.notifyListeners(false, unlockedObjectIds.toArray(new ObjectId[unlockedObjectIds.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockAll() {
        ObjectId[] objectIds = null;
        HashSet hashSet = this.lockedObjects;
        synchronized (hashSet) {
            objectIds = this.lockedObjects.toArray(new ObjectId[this.lockedObjects.size()]);
            this.lockedObjects.clear();
        }
        if (objectIds != null && objectIds.length > 0) {
            this.notifyListeners(false, objectIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocked(ObjectId objectId) {
        HashSet hashSet = this.lockedObjects;
        synchronized (hashSet) {
            return this.lockedObjects.contains(objectId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getLockedObjectIds() {
        HashSet hashSet = this.lockedObjects;
        synchronized (hashSet) {
            return (Set)this.lockedObjects.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(boolean add, ObjectId[] objectIds) {
        List list = this.listeners;
        synchronized (list) {
            int size = this.listeners.size();
            int i = 0;
            while (i < size) {
                LockListener listener = (LockListener)this.listeners.get(i);
                if (add) {
                    listener.objectsLocked(objectIds);
                } else {
                    listener.objectsUnlocked(objectIds);
                }
                ++i;
            }
        }
    }
}

